local BC = rawget(_G, "EURY_COOKINGUI") or {}
_G.EURY_COOKINGUI = BC

BC.Options = BC.Options or {}
local OPS = BC.Options

local options = PZAPI.ModOptions:create("EURY_COOKINGUI", "Better Cooking")

OPS.enableIngredientSubMenu = options:addTickBox(
    "enableIngredientSubMenu",
    getTextOrNull("UI_BetterCooking_Ingredients_SubMenu") or "Ingredients Sub-Menu",
    true,
    getTextOrNull("UI_BetterCooking_Ingredients_SubMenu_tooltips") or "Puts all Ingredients into an Ingredients Sub-menu."
)
OPS.enableSeasoningSubMenu = options:addTickBox(
    "enableSeasoningSubMenu",
    getTextOrNull("UI_BetterCooking_Seasonings_SubMenu") or "Seasonings Sub-Menu",
    true,
    getTextOrNull("UI_BetterCooking_Seasonings_SubMenu_tooltip") or "Puts all Seasonings into a Seasonings Sub-menu."
)
OPS.enableQuantitySuffix = options:addTickBox(
    "enableQuantitySuffix",
    getTextOrNull("UI_BetterCooking_QuantitySuffix") or "Quantity Suffix",
    true,
    getTextOrNull("UI_BetterCooking_QuantitySuffix_tooltip") or "Displays the Quantity of items available for a seasoning/ingredient as a suffix."
)
OPS.enableSpoilageSort = options:addTickBox(
    "enableSpoilageSort",
    getTextOrNull("UI_BetterCooking_SortBySpoilage") or "Sort by Spoilage",
    true,
    getTextOrNull("UI_BetterCooking_SortBySpoilage_tooltip") or "This will ensure the seasoning/ingredient shown is the first that will spoil. (Sorted by spoilage THEN uses)"
)
OPS.enableUsesSort = options:addTickBox(
    "enableUsesSort",
    getTextOrNull("UI_BetterCooking_SortByUsesRemaining") or "Sort by Uses Remaining",
    true,
    getTextOrNull("UI_BetterCooking_SortByUsesRemaining") or "This will sort seasonings by the lowest remaining uses. (Sorted by spoilage THEN uses)."
)

options:addDescription(getTextOrNull("UI_BetterCooking_Ingredients_Info") or "Ingredients will always show the largest available +hunger and first to spoil, sorted alphabetically.")

OPS.enableIngredientPartial = options:addTickBox(
    "enableIngredientPartial",
    getTextOrNull("UI_BetterCooking_Ingredients_ShowPartial") or "Show Partial Ingredients",
    false,
    getTextOrNull("UI_BetterCooking_Ingredients_ShowPartial_tooltip") or "Adds an entry to the ingredients list that will show partial hunger values, largest partial and first to spoil. (Depending on prior options)"
)

options:addDescription(getTextOrNull("UI_BetterCooking_Rotten_Info") or "Choose how to handle Rotten entries in the menu")

OPS.showRottenIngredientGroup = options:addTickBox(
    "showRottenIngredientGroup",
    getTextOrNull("UI_BetterCooking_Ingredients_ShowRotten") or "Show Rotten Ingredients",
    true,
    getTextOrNull("UI_BetterCooking_Ingredients_ShowRotten_tooltip") or "Adds an entry to the ingredients list that will show rotten items."
)

OPS.showRottenSeasoningGroup = options:addTickBox(
    "showRottenSeasoningGroup",
    getTextOrNull("UI_BetterCooking_Seasonings_ShowRotten") or "Show Rotten Seasonings",
    true,
    getTextOrNull("UI_BetterCooking_Seasonings_ShowRotten_tooltip") or "Adds an entry to the seasonings list that will show rotten items."
)

function options:apply()
end

function OPS.shouldUseSeasoningsSubMenu()
    local result = OPS.enableSeasoningSubMenu and OPS.enableSeasoningSubMenu:getValue() == true
    return result
end

function OPS.shouldUseIngredientsSubMenu()
    local result = OPS.enableIngredientSubMenu and OPS.enableIngredientSubMenu:getValue() == true
    return result
end

function OPS.shouldShowQuantity()
    local result = OPS.enableQuantitySuffix and OPS.enableQuantitySuffix:getValue() == true
    return result
end

function OPS.shouldSortBySpoilage()
    local result = OPS.enableSpoilageSort and OPS.enableSpoilageSort:getValue() == true
    return result
end

function OPS.shouldSortByUsesRemaining()
    local result = OPS.enableUsesSort and OPS.enableUsesSort:getValue() == true
    return result
end

function OPS.shouldShowPartialIngredients()
    local result = OPS.enableIngredientPartial and OPS.enableIngredientPartial:getValue() == true
    return result
end

function OPS.shouldShowRottenIngredientGroup()
    local result = OPS.showRottenIngredientGroup and OPS.showRottenIngredientGroup:getValue() == true
    return result
end

function OPS.shouldShowRottenSeasoningGroup()
    local result = OPS.showRottenSeasoningGroup and OPS.showRottenSeasoningGroup:getValue() == true
    return result
end